/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JRadioButtonMenuItem;

public class RibPrinterMenu {
    CurveDraw curvedraw;
    JMenuBar menuBar;
    RibPrinterVariables rpv;

    public JMenuBar getMenu() {
        return this.menuBar;
    }

    JMenu buildNACAMenu() {
        JMenu nacaMenu = new JMenu("NACA");
        nacaMenu.addSeparator();
        JMenuItem NACA4digitJMenuItem = new JMenuItem("4-Digit");
        JMenuItem NACA5digitJMenuItem = new JMenuItem("5-Digit");
        nacaMenu.add(NACA4digitJMenuItem);
        nacaMenu.add(NACA5digitJMenuItem);
        return nacaMenu;
    }

    JMenu buildProfileMenu() {
        JMenu profileMenu = new JMenu("Profile");
        profileMenu.setMnemonic(80);
        JMenuItem XJMenuItem = new JMenuItem("X");
        profileMenu.add(XJMenuItem);
        JMenu Axis_Menu = new JMenu("Axis");
        profileMenu.add(Axis_Menu);
        JMenu X_Axis_Labels_Menu = new JMenu("X_Axis_Labels");
        Axis_Menu.add(X_Axis_Labels_Menu);
        final JCheckBoxMenuItem X_Axis_Labels_Check = new JCheckBoxMenuItem("X_Axis_Labels");
        Axis_Menu.add(X_Axis_Labels_Check);
        X_Axis_Labels_Check.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                System.out.println("Checked? " + X_Axis_Labels_Check.isSelected());
                RibPrinterMenu.this.rpv.X_Axis_Labels = X_Axis_Labels_Check.isSelected();
                RibPrinterMenu.this.curvedraw.repaint();
            }
        });
        final JCheckBoxMenuItem Y_Axis_Labels_Check = new JCheckBoxMenuItem("Y_Axis_Labels");
        Axis_Menu.add(Y_Axis_Labels_Check);
        Y_Axis_Labels_Check.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                System.out.println("Checked? " + X_Axis_Labels_Check.isSelected());
                RibPrinterMenu.this.rpv.Y_Axis_Labels = Y_Axis_Labels_Check.isSelected();
                RibPrinterMenu.this.curvedraw.repaint();
            }
        });
        profileMenu.addSeparator();
        JMenuItem cordJMenuItem = new JMenuItem("Cord Length");
        profileMenu.add(cordJMenuItem);
        cordJMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                System.out.println("You have clicked on Cord Length");
                String msg = "Cord Length?";
                String results = null;
                JFrame frame = new JFrame("Title");
                String initial = Integer.toString(RibPrinterMenu.this.rpv.length_of_rib);
                results = JOptionPane.showInputDialog(frame, msg, initial);
                if (results != null && results.length() > 0) {
                    System.out.println("Results: " + results);
                    int length_of_rib = Integer.parseInt(results);
                    System.out.println("length_of_rib: " + length_of_rib);
                    RibPrinterMenu.this.rpv.length_of_rib = length_of_rib;
                    RibPrinterMenu.this.curvedraw.repaint();
                }
            }
        });
        profileMenu.addSeparator();
        JMenuItem stationsJMenuItem = new JMenuItem("Stations");
        profileMenu.add(stationsJMenuItem);
        stationsJMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                System.out.println("You have clicked on Stations");
                String msg = "How many stations?";
                String results = null;
                JFrame frame = new JFrame("Title");
                String initial = Integer.toString(RibPrinterMenu.this.rpv.stations);
                results = JOptionPane.showInputDialog(frame, msg, initial);
                if (results != null && results.length() > 0) {
                    System.out.println("Results: " + results);
                    int value = Integer.parseInt(results);
                    System.out.println("value: " + value);
                    RibPrinterMenu.this.rpv.stations = value;
                    RibPrinterMenu.this.curvedraw.repaint();
                }
            }
        });
        JMenu stationSpacingMenu = new JMenu("Station Spacing");
        profileMenu.add(stationSpacingMenu);
        final JCheckBoxMenuItem linear_spacing_Check = new JCheckBoxMenuItem("linear");
        final JCheckBoxMenuItem halfcosine_spacing_Check = new JCheckBoxMenuItem("halfcosine");
        final JCheckBoxMenuItem cosine_spacing_Check = new JCheckBoxMenuItem("cosine");
        stationSpacingMenu.add(linear_spacing_Check);
        stationSpacingMenu.add(halfcosine_spacing_Check);
        stationSpacingMenu.add(cosine_spacing_Check);
        linear_spacing_Check.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                System.out.println("Checked? " + linear_spacing_Check.isSelected());
                RibPrinterMenu.this.rpv.linear_spacing = linear_spacing_Check.isSelected();
                RibPrinterMenu.this.curvedraw.repaint();
            }
        });
        halfcosine_spacing_Check.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                System.out.println("Checked? " + halfcosine_spacing_Check.isSelected());
                RibPrinterMenu.this.rpv.halfcosine_spacing = halfcosine_spacing_Check.isSelected();
                RibPrinterMenu.this.curvedraw.repaint();
            }
        });
        cosine_spacing_Check.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                System.out.println("Checked? " + cosine_spacing_Check.isSelected());
                RibPrinterMenu.this.rpv.cosine_spacing = cosine_spacing_Check.isSelected();
                RibPrinterMenu.this.curvedraw.repaint();
            }
        });
        profileMenu.addSeparator();
        JMenuItem YJMenuItem = new JMenuItem("Y");
        profileMenu.add(YJMenuItem);
        return profileMenu;
    }

    public RibPrinterMenu(CurveDraw curvedraw, RibPrinterVariables rpv) {
        this.curvedraw = curvedraw;
        this.rpv = rpv;
        this.menuBar = new JMenuBar();
        this.menuBar.setOpaque(true);
        this.menuBar.setBackground(new Color(154, 165, 127));
        this.menuBar.setPreferredSize(new Dimension(200, 20));
        JMenu fileMenu = new JMenu("File");
        JMenu editMenu = new JMenu("Edit");
        this.menuBar.add(fileMenu);
        this.menuBar.add(editMenu);
        this.menuBar.add(this.buildProfileMenu());
        this.menuBar.add(this.buildNACAMenu());
        JMenuItem newAction = new JMenuItem("New");
        JMenuItem openAction = new JMenuItem("Open");
        JMenuItem exitAction = new JMenuItem("Exit");
        JMenuItem cutAction = new JMenuItem("Cut");
        JMenuItem copyAction = new JMenuItem("Copy");
        JMenuItem pasteAction = new JMenuItem("Paste");
        JMenuItem printAction = new JMenuItem("Print");
        JCheckBoxMenuItem checkAction = new JCheckBoxMenuItem("Check Action");
        JRadioButtonMenuItem radioAction1 = new JRadioButtonMenuItem("Radio Button1");
        JRadioButtonMenuItem radioAction2 = new JRadioButtonMenuItem("Radio Button2");
        ButtonGroup bg = new ButtonGroup();
        bg.add(radioAction1);
        bg.add(radioAction2);
        fileMenu.add(newAction);
        fileMenu.add(openAction);
        fileMenu.add(checkAction);
        fileMenu.addSeparator();
        fileMenu.add(printAction);
        fileMenu.addSeparator();
        JMenu exportMenu = new JMenu("Export");
        JMenuItem DXFAction = new JMenuItem("DXF");
        JMenuItem SGVAction = new JMenuItem("SVG");
        JMenuItem TXTction = new JMenuItem("TXT");
        exportMenu.add(DXFAction);
        exportMenu.add(SGVAction);
        exportMenu.add(TXTction);
        fileMenu.add(exportMenu);
        fileMenu.addSeparator();
        fileMenu.add(exitAction);
        editMenu.add(cutAction);
        editMenu.add(copyAction);
        editMenu.add(pasteAction);
        editMenu.addSeparator();
        editMenu.add(radioAction1);
        editMenu.add(radioAction2);
        newAction.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                System.out.println("You have clicked on the new action");
            }
        });
        Dimension d = new Dimension(1584, 576);
        HelloWorldPrinter t = new HelloWorldPrinter(curvedraw, rpv);
        printAction.addActionListener(t);
    }
}

