/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.UIManager;

public class HelloWorldPrinter
implements Printable,
ActionListener {
    public static Dimension drawingExtents;
    Dimension pages;
    Dimension printable_Area;
    double width_in_pages;
    double width_remainder;
    double height_in_pages;
    double height_remainder;
    int total_pages;
    CurveDraw curvedraw;
    RibPrinterVariables rpv;

    HelloWorldPrinter() {
        CurveDraw curvedraw;
        this.rpv = new RibPrinterVariables();
        this.curvedraw = curvedraw = new CurveDraw(this.rpv);
        this.setDrawingExtents();
    }

    HelloWorldPrinter(CurveDraw curvedraw, RibPrinterVariables rpv) {
        this.curvedraw = curvedraw;
        this.rpv = rpv;
        this.setDrawingExtents();
    }

    public void set_drawingExtents(Dimension d) {
        drawingExtents = d;
    }

    void DisplayPageFormatInfo(PageFormat pf) {
        System.out.println(" ");
        System.out.println("    pf.getImageableX() : " + pf.getImageableX());
        System.out.println("    pf.getImageableY() : " + pf.getImageableY());
        System.out.println("  printable_Area");
        System.out.println("    pf.getImageableWidth()  : " + pf.getImageableWidth());
        System.out.println("    pf.getImageableHeight() : " + pf.getImageableHeight());
    }

    void setDrawingExtents() {
        Dimension drawingExtents = new Dimension(360, 360);
        drawingExtents = new Dimension(468, 648);
        drawingExtents = new Dimension(720, 576);
        drawingExtents = new Dimension(936, 648);
        drawingExtents = new Dimension(1368, 504);
        drawingExtents = new Dimension(1404, 648);
        drawingExtents = new Dimension(1584, 288);
        drawingExtents = new Dimension(1584, 576);
        drawingExtents = new Dimension(1584, 648);
        drawingExtents = new Dimension(1116, 1008);
        drawingExtents = new Dimension(1404, 1296);
        drawingExtents = new Dimension(1188, 1512);
        drawingExtents = new Dimension(1404, 1944);
        drawingExtents = new Dimension(2268, 3744);
        drawingExtents = new Dimension(2340, 3888);
        drawingExtents = new Dimension(936, 1296);
        drawingExtents = new Dimension(936, 648);
        drawingExtents = new Dimension(720, 288);
        System.out.println(" ");
        System.out.println(" drawingExtents : " + drawingExtents);
        this.set_drawingExtents(drawingExtents);
    }

    @Override
    public int print(Graphics g, PageFormat pf, int page) throws PrinterException {
        System.out.println(" ");
        System.out.println("  Current Printing page   : " + page);
        this.DisplayPageFormatInfo(pf);
        this.printable_Area = new Dimension((int)pf.getImageableWidth(), (int)pf.getImageableHeight());
        System.out.println(" ");
        System.out.println(" printable_Area : " + this.printable_Area);
        this.width_in_pages = HelloWorldPrinter.drawingExtents.width / this.printable_Area.width + 1;
        this.width_remainder = this.printable_Area.width - HelloWorldPrinter.drawingExtents.width % this.printable_Area.width;
        if (this.width_remainder == (double)this.printable_Area.width) {
            this.width_in_pages -= 1.0;
            this.width_remainder = 0.0;
        }
        this.height_in_pages = HelloWorldPrinter.drawingExtents.height / this.printable_Area.height + 1;
        this.height_remainder = this.printable_Area.height - HelloWorldPrinter.drawingExtents.height % this.printable_Area.height;
        if (this.height_remainder == (double)this.printable_Area.height) {
            this.height_in_pages -= 1.0;
            this.height_remainder = 0.0;
        }
        System.out.println(" ");
        System.out.println(" width_in_pages    : " + this.width_in_pages);
        System.out.println(" width_remainder   : " + this.width_remainder);
        System.out.println(" height_in_pages   : " + this.height_in_pages);
        System.out.println(" height_remainder  : " + this.height_remainder);
        this.pages = new Dimension((int)this.width_in_pages, (int)this.height_in_pages);
        System.out.println(" pages : " + this.pages);
        this.total_pages = this.pages.width * this.pages.height;
        System.out.println(" total_pages : " + this.total_pages);
        if (page > this.total_pages - 1) {
            return 1;
        }
        this.printparts(g, pf, page);
        return 0;
    }

    public void printparts(Graphics g, PageFormat pf, int page) {
        Graphics2D g2d = (Graphics2D)g;
        double x1 = pf.getImageableX();
        double y1 = pf.getImageableY();
        g2d.translate(x1, y1);
        double x2 = page % this.pages.width * -this.printable_Area.width;
        double y2 = page / this.pages.width * -this.printable_Area.height;
        g2d.translate(x2, y2);
        this.Draw_Page_Boundry(g2d, page);
        this.Draw_X_in_page(g2d, page);
        this.Draw_Page_X_of_Y(g2d, page);
        double x3 = this.width_remainder / 2.0;
        double y3 = this.height_remainder / 2.0;
        g2d.translate(x3, y3);
        g2d.setColor(Color.magenta);
        g2d.drawLine(0, 0, HelloWorldPrinter.drawingExtents.width, 0);
        g2d.drawLine(0, 0, 0, HelloWorldPrinter.drawingExtents.height);
        g2d.drawLine(HelloWorldPrinter.drawingExtents.width, HelloWorldPrinter.drawingExtents.height, HelloWorldPrinter.drawingExtents.width, 0);
        g2d.drawLine(HelloWorldPrinter.drawingExtents.width, HelloWorldPrinter.drawingExtents.height, 0, HelloWorldPrinter.drawingExtents.height);
        g2d.drawLine(0, 0, HelloWorldPrinter.drawingExtents.width, HelloWorldPrinter.drawingExtents.height);
        g2d.drawLine(0, HelloWorldPrinter.drawingExtents.height, HelloWorldPrinter.drawingExtents.width, 0);
        this.additions(g2d);
    }

    void Draw_Page_Boundry(Graphics g, int page) {
        int minX = (int)((double)page % this.width_in_pages) * this.printable_Area.width;
        int maxX = minX + this.printable_Area.width;
        int minY = (int)((double)page / this.width_in_pages) * this.printable_Area.height;
        int maxY = minY + this.printable_Area.height;
        g.setColor(Color.red);
        g.drawLine(minX, minY, maxX, minY);
        g.drawLine(maxX, minY, maxX, maxY);
        g.drawLine(maxX, maxY, minX, maxY);
        g.drawLine(minX, maxY, minX, minY);
    }

    void Draw_X_in_page(Graphics g, int page) {
        int minX = (int)((double)page % this.width_in_pages) * this.printable_Area.width;
        int maxX = minX + this.printable_Area.width;
        int minY = (int)((double)page / this.width_in_pages) * this.printable_Area.height;
        int maxY = minY + this.printable_Area.height;
        g.setColor(Color.green);
        g.drawLine(minX, minY, maxX, maxY);
        g.drawLine(maxX, minY, minX, maxY);
    }

    void Draw_Page_X_of_Y(Graphics2D g2d, int page) {
        int minX = (int)((double)page % this.width_in_pages) * this.printable_Area.width;
        int maxX = minX + this.printable_Area.width;
        int minY = (int)((double)page / this.width_in_pages) * this.printable_Area.height;
        int maxY = minY + this.printable_Area.height;
        int x2 = page % this.pages.width + 1;
        int y2 = page / this.pages.width + 1;
        String string = "Page " + (page + 1) + " of " + this.total_pages;
        g2d.drawString(string, minX + 25, minY + 25);
        string = "( " + x2 + " , " + y2 + " )";
        g2d.drawString(string, minX + 25, minY + 50);
    }

    void additions(Graphics2D g) {
        this.curvedraw.BuildDisplay(g);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Dimension d1 = new Dimension(720, 288);
        Dimension d2 = new Dimension(72 * this.rpv.length_of_rib + 288, 72 * this.rpv.length_of_rib / 2 + 144);
        this.set_drawingExtents(d2);
        PrinterJob job = PrinterJob.getPrinterJob();
        HashPrintRequestAttributeSet aset = new HashPrintRequestAttributeSet();
        PageFormat pf = job.pageDialog(aset);
        boolean ok = false;
        if (pf != null) {
            job.setPrintable(this, pf);
            ok = job.printDialog(aset);
        }
        if (ok) {
            Dimension current_Dimension = this.curvedraw.Get_Dimension();
            this.curvedraw.Set_Dimension(new Dimension(72 * this.rpv.length_of_rib, 72 * this.rpv.length_of_rib / 2));
            try {
                job.print();
            }
            catch (PrinterException ex) {
                // empty catch block
            }
            this.curvedraw.Set_Dimension(current_Dimension);
        }
    }

    public static void main(String[] args) {
        UIManager.put("swing.boldMetal", Boolean.FALSE);
        JFrame f = new JFrame("Hello World Printer");
        f.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        JButton printButton = new JButton("Print Hello World");
        printButton.addActionListener(new HelloWorldPrinter());
        f.add("Center", printButton);
        f.pack();
        f.setVisible(true);
    }
}

