/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.text.DecimalFormat;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.SwingUtilities;

public class CurveDraw
extends Canvas {
    static final int POSITION_TOP = 1;
    static final int POSITION_BOTTOM = 2;
    double[] NACA2412_Cosine = new double[]{1.0, 0.00126, 0.975528, 0.006241, 0.904508, 0.019774, 0.793893, 0.038286, 0.654508, 0.057319, 0.5, 0.072385, 0.345492, 0.079203, 0.206107, 0.073015, 0.095492, 0.054458, 0.024472, 0.028266, 0.0, 0.0, 0.024472, -0.023521, 0.095492, -0.03764, 0.206107, -0.042413, 0.345492, -0.039946, 0.5, -0.033496, 0.654508, -0.024516, 0.793893, -0.015525, 0.904508, -0.008055, 0.975528, -0.003044, 1.0, -0.00126};
    double[] NACA2412_Linear = new double[]{1.0, 0.00126, 0.9, 0.020588, 0.8, 0.037342, 0.7, 0.051639, 0.6, 0.063411, 0.5, 0.072385, 0.4, 0.07803, 0.3, 0.078767, 0.2, 0.072375, 0.1, 0.055578, 0.0, 0.0, 0.1, -0.038078, 0.2, -0.042375, 0.3, -0.041267, 0.4, -0.03803, 0.5, -0.033496, 0.6, -0.027856, 0.7, -0.021639, 0.8, -0.01512, 0.9, -0.008366, 1.0, -0.00126};
    Dimension d1;
    final int hashmark_length_X = 25;
    final int hashmark_length_Y = 25;
    final int offsetX = 50;
    final int offsetY = 50;
    RibPrinterVariables prv;

    public CurveDraw(RibPrinterVariables prv) {
        this.prv = prv;
        this.Set_Dimension(new Dimension(72 * prv.length_of_rib, 72 * prv.length_of_rib / 2));
    }

    public void Set_Dimension(Dimension d) {
        this.d1 = d;
    }

    public Dimension Get_Dimension() {
        Dimension d = new Dimension();
        d = this.d1;
        return d;
    }

    public void paintComponent(Graphics g) {
        this.paintX(g);
    }

    @Override
    public void paint(Graphics g) {
        this.paintX(g);
    }

    public void paintX(Graphics g) {
        int width = this.getWidth();
        int height = this.getHeight();
        g.clearRect(0, 0, width, height);
        System.out.println("1)  d = " + this.d1);
        this.BuildDisplay(g);
        System.out.println("2)  d = " + this.d1);
        System.out.println(" ");
    }

    public void BuildDisplay(Graphics g) {
        this.setupDisplay(g);
        double[] array = this.NACA2412_Linear;
        g.setColor(Color.blue);
        this.plotit(g, array);
        array = this.NACA2412_Cosine;
        g.setColor(Color.red);
        this.plotit(g, array);
        Spars spars = new Spars(this.prv, this.d1, 50, 50);
        Spars.DrawSpars(g);
    }

    public void plotSpars(Graphics g, double[] anArray) {
        for (int i = 4; i < anArray.length + 1; i += 2) {
            double x1 = anArray[i - 4];
            double y1 = anArray[i - 3];
            double x2 = anArray[i - 2];
            double y2 = anArray[i - 1];
            g.drawLine(50 + (int)((double)this.d1.width * x1), (int)(50.0 + (double)this.d1.height / 2.0 - y1 * (double)this.d1.width), 50 + (int)((double)this.d1.width * x2), (int)(50.0 + (double)this.d1.height / 2.0 - y2 * (double)this.d1.width));
        }
    }

    public void plotit(Graphics g, double[] anArray) {
        for (int i = 4; i < anArray.length + 1; i += 2) {
            double x1 = anArray[i - 4];
            double y1 = anArray[i - 3];
            double x2 = anArray[i - 2];
            double y2 = anArray[i - 1];
            g.drawLine(50 + (int)((double)this.d1.width * x1), (int)(50.0 + (double)this.d1.height / 2.0 - y1 * (double)this.d1.width), 50 + (int)((double)this.d1.width * x2), (int)(50.0 + (double)this.d1.height / 2.0 - y2 * (double)this.d1.width));
        }
    }

    public void plotit(Graphics g, double[] anArray, double scale) {
        for (int i = 4; i < anArray.length + 1; i += 2) {
            double x1 = anArray[i - 4];
            double y1 = anArray[i - 3];
            double x2 = anArray[i - 2];
            double y2 = anArray[i - 1];
            g.drawLine(50 + (int)((double)this.d1.width / scale * x1), (int)(50.0 + (double)this.d1.height / 2.0 - y1 * (double)this.d1.width / scale), 50 + (int)((double)this.d1.width / scale * x2), (int)(50.0 + (double)this.d1.height / 2.0 - y2 * (double)this.d1.width / scale));
        }
    }

    public void StatonsMarksLinear(Graphics g, int offsetX, int offsetY, int stations, Dimension d, Font font) {
        for (int i = 0; i <= stations; ++i) {
            int x = offsetX + (int)((double)i / (double)stations * (double)d.width);
            g.drawLine(x, offsetY, x, offsetY + d.height);
        }
    }

    public void StatonsMarksLinearLabels(Graphics g, int offsetX, int offsetY, int stations, Dimension d, Font font) {
        Graphics2D g2d = (Graphics2D)g;
        for (int i = 0; i <= stations; ++i) {
            int x = offsetX + (int)((double)i / (double)stations * (double)this.d1.width);
            String text = Integer.toString(i);
            FontMetrics metrics = g.getFontMetrics(font);
            int font_height = metrics.getHeight();
            int font_descent = metrics.getMaxDescent();
            int halfstrwidth = metrics.stringWidth(text) / 2;
            g.drawString(text, x - halfstrwidth, offsetY - font_descent);
            g.drawString(text, x - halfstrwidth, offsetY + this.d1.height + font_height);
        }
    }

    public void StatonsMarksHalfCosine(Graphics g, int offsetX, int offsetY, int stations, Dimension d, Font font) {
        for (int i = 0; i <= stations; ++i) {
            double val = 1.0 - Math.cos(1.5707963267948966 * ((double)i / (double)stations));
            int x = offsetX + (int)((double)this.d1.width * val);
            g.drawLine(x, offsetY, x, offsetY + this.d1.height);
        }
    }

    public void StatonsMarksHalfCosineLabels(Graphics g, int offsetX, int offsetY, int stations, Dimension d, Font font) {
        Graphics2D g2d = (Graphics2D)g;
        for (int i = 0; i <= stations; ++i) {
            double val = 1.0 - Math.cos(1.5707963267948966 * ((double)i / (double)stations));
            int x = offsetX + (int)((double)this.d1.width * val);
            String text = Integer.toString(i);
            FontMetrics metrics = g.getFontMetrics(font);
            int font_height = metrics.getHeight();
            int font_descent = metrics.getMaxDescent();
            int halfstrwidth = metrics.stringWidth(text) / 2;
            g.drawString(text, x - halfstrwidth, offsetY - font_descent);
            g.drawString(text, x - halfstrwidth, offsetY + this.d1.height + font_height);
        }
    }

    public void StatonsMarksCosine(Graphics g, int offsetX, int offsetY, int stations, Dimension d, Font font) {
        for (int i = 0; i <= stations; ++i) {
            double val = 1.0 - Math.cos(Math.PI * ((double)i / (double)stations));
            int x = offsetX + (int)((double)this.d1.width / 2.0 * val);
            g.drawLine(x, offsetY, x, offsetY + this.d1.height);
        }
    }

    public void StatonsMarksCosineLabels(Graphics g, int offsetX, int offsetY, int stations, Dimension d, Font font) {
        Graphics2D g2d = (Graphics2D)g;
        FontMetrics metrics = g.getFontMetrics(font);
        int font_height = metrics.getHeight();
        int font_descent = metrics.getMaxDescent();
        for (int i = 0; i <= stations; ++i) {
            double val = 1.0 - Math.cos(Math.PI * ((double)i / (double)stations));
            int x = offsetX + (int)((double)this.d1.width * val / 2.0);
            String text = Integer.toString(i);
            int halfstrwidth = metrics.stringWidth(text) / 2;
            g.drawString(text, x - halfstrwidth, offsetY - font_descent);
            g.drawString(text, x - halfstrwidth, offsetY + this.d1.height + font_height);
        }
    }

    public void X_Axis_MarksSave(Graphics g, int offsetX, int offsetY, int stations, Dimension d, Font font, double range) {
        Graphics2D g2d = (Graphics2D)g;
        double x_val = 0.0;
        double delta = range / (double)stations;
        FontMetrics metrics = g.getFontMetrics(font);
        int font_height = metrics.getHeight();
        int font_descent = metrics.getMaxDescent();
        DecimalFormat df = new DecimalFormat("#.##");
        df = new DecimalFormat("0.00");
        double w = metrics.stringWidth("000.00");
        if ((double)(this.d1.width / stations) < w) {
            df = new DecimalFormat("0.0");
        }
        for (int i = 0; i <= stations; ++i) {
            int x = offsetX + (int)((double)this.d1.width * ((double)i / (double)stations));
            int y1 = offsetY + this.d1.height / 2 - 5;
            y1 = offsetY + this.d1.height;
            int y2 = y1 + 10;
            g.drawLine(x, y1, x, y2);
            String text = df.format(x_val);
            int halfstrwidth = metrics.stringWidth(text) / 2;
            g.drawString(text, x - halfstrwidth, y2 + font_height);
            x_val += delta;
        }
    }

    public void X_Axis_Marks(Graphics g, int offsetX, int offsetY, int stations, Dimension d, Font font, double range) {
        for (int i = 0; i <= stations; ++i) {
            int x = offsetX + (int)((double)d.width * ((double)i / (double)stations));
            int y = offsetY + d.height / 2 - 12;
            g.drawLine(x, y, x, y + 25);
        }
    }

    public void X_Axis_MarksLabel(Graphics g, int offsetX, int offsetY, int stations, Dimension d, Font font, double range, int position) {
        Graphics2D g2d = (Graphics2D)g;
        double x_val = 0.0;
        double delta = range / (double)stations;
        FontMetrics metrics = g.getFontMetrics(font);
        int font_height = metrics.getHeight();
        int font_descent = metrics.getMaxDescent();
        DecimalFormat df = new DecimalFormat("#.##");
        df = new DecimalFormat("0.00");
        double w = metrics.stringWidth("000.00");
        if ((double)(this.d1.width / stations) < w) {
            df = new DecimalFormat("0.0");
        }
        for (int i = 0; i <= stations; ++i) {
            int y;
            int x = offsetX + (int)((double)this.d1.width * ((double)i / (double)stations));
            String text = df.format(x_val);
            int halfstrwidth = metrics.stringWidth(text) / 2;
            x_val += delta;
            if (position == 1) {
                y = offsetY + this.d1.height / 2 - 12 - font_descent;
                g.drawString(text, x - halfstrwidth, y);
            }
            if (position != 2) continue;
            y = offsetY + this.d1.height / 2 + 12 + font_height;
            g.drawString(text, x - halfstrwidth, y);
        }
    }

    public void Y_Axis_Marks(Graphics g, int offsetX, int offsetY, int stations, Dimension d, Font font, double delta) {
        double t2;
        int x1 = offsetX;
        int x2 = offsetX + this.d1.width;
        int y = offsetY + (int)((double)this.d1.height / 2.0);
        for (int i = 0; i <= stations && !((t2 = (double)this.d1.width / (1.0 / delta) * (double)i) > (double)this.d1.width / 2.0); ++i) {
            g.drawLine(x1, (int)((double)y - t2), x2, (int)((double)y - t2));
            g.drawLine(x1, (int)((double)y + t2), x2, (int)((double)y + t2));
        }
    }

    public void Y_Axis_MarksLabel1(Graphics g, int offsetX, int offsetY, int stations, Dimension d, Font font, double delta) {
        Graphics2D g2d = (Graphics2D)g;
        double y_val = 0.0;
        double deltay = 0.02;
        deltay = (double)this.d1.height / 2.0 / (double)stations;
        FontMetrics metrics = g.getFontMetrics(font);
        int font_height = metrics.getHeight();
        int font_descent = metrics.getMaxDescent();
        double t1 = metrics.getAscent();
        double t2 = metrics.getDescent();
        double t4 = metrics.getLeading();
        double t3 = t1 + t2;
        DecimalFormat df = new DecimalFormat("#.##");
        df = new DecimalFormat("0.00");
        for (int i = 0; i <= stations; ++i) {
            int x = offsetX + this.d1.width;
            int y = offsetY + (int)((double)this.d1.height / 2.0 + (double)this.d1.height / 2.0 * (double)i / (double)stations);
            g.setColor(Color.red);
            g.drawLine(x - 50, y, x + 25, y);
            g.setColor(Color.green);
            g.drawRect(x, y - (int)t1, 50, (int)t3);
            String text = df.format(y_val);
            y_val += deltay;
            g.drawString(text, x, y);
        }
    }

    public void Y_Axis_MarksLabel(Graphics g, int offsetX, int offsetY, int stations, Dimension d, Font font, double delta, double range) {
        Graphics2D g2d = (Graphics2D)g;
        double y_val = 0.0;
        double deltay = 0.02;
        deltay = (double)this.d1.height / 2.0 / (double)stations;
        FontMetrics metrics = g.getFontMetrics(font);
        int font_height = metrics.getHeight();
        int font_descent = metrics.getMaxDescent();
        double t1 = metrics.getAscent();
        double t2 = metrics.getDescent();
        double t4 = metrics.getLeading();
        double t3 = t1 + t2;
        DecimalFormat df = new DecimalFormat("#.##");
        df = new DecimalFormat("0.0000");
        for (int i = 0; i <= stations; ++i) {
            int x = offsetX + this.d1.width;
            int y = offsetY + (int)((double)this.d1.height / 2.0);
            t2 = 1.0 / delta;
            double t5 = (double)this.d1.width / t2 * (double)i;
            if (t5 > (double)this.d1.height / 2.0) break;
            g.setColor(Color.blue);
            g.drawLine(x, (int)((double)y - t5), x + 25, (int)((double)y - t5));
            if (i != 0) {
                g.drawLine(x, (int)((double)y + t5), x + 25, (int)((double)y + t5));
            }
            String text = df.format((double)i * delta * range);
            g.drawString(text, x - metrics.stringWidth(text), (int)((double)y - t5));
            if (i == 0) continue;
            text = df.format((double)i * delta * range * -1.0);
            g.drawString(text, x - metrics.stringWidth(text), (int)((double)y + t5));
        }
    }

    public void setupDisplay(Graphics g) {
        g.setColor(Color.blue);
        String[] font_name = new String[]{"serif", "sansserif", "monospaced"};
        int[] font_style = new int[]{0, 1, 2, 3};
        Font font1 = new Font(font_name[0], font_style[0], 12);
        Font font2 = new Font(font_name[1], font_style[0], 24);
        Font font3 = new Font(font_name[2], font_style[0], 36);
        Font font4 = new Font("Garamond", 0, 16);
        Font font5 = new Font("Book Antiqua", 0, 16);
        Font font6 = new Font("Courier New", 0, 16);
        Font font7 = new Font("Courier New", 0, 12);
        g.setFont(font7);
        Font font = g.getFont();
        g.setColor(Color.black);
        g.drawRect(50, 50, this.d1.width, this.d1.height);
        g.drawLine(50, 50 + this.d1.height / 2, 50 + this.d1.width, 50 + this.d1.height / 2);
        FontMetrics metrics = g.getFontMetrics(font);
        int font_height = metrics.getHeight();
        int font_descent = metrics.getMaxDescent();
        Color temp_color = g.getColor();
        if (this.prv.linear_spacing) {
            g.setColor(this.prv.linear_spacing_Color);
            this.StatonsMarksLinear(g, 50, 50, this.prv.stations, this.d1, font);
            this.StatonsMarksLinearLabels(g, 50, 50, this.prv.stations, this.d1, font);
        }
        if (this.prv.halfcosine_spacing) {
            g.setColor(this.prv.halfcosine_spacing_Color);
            this.StatonsMarksHalfCosine(g, 50, 50, this.prv.stations, this.d1, font);
            this.StatonsMarksHalfCosineLabels(g, 50, 50, this.prv.stations, this.d1, font);
        }
        if (this.prv.cosine_spacing) {
            g.setColor(this.prv.cosine_spacing_Color);
            this.StatonsMarksCosine(g, 50, 50, this.prv.stations, this.d1, font);
            this.StatonsMarksCosineLabels(g, 50, 50, this.prv.stations, this.d1, font);
        }
        g.setColor(temp_color);
        if (this.prv.X_Axis_Labels) {
            int shift_down = 0;
            this.X_Axis_Marks(g, 50, 50 + shift_down, this.prv.length_of_rib * 2, this.d1, font, this.prv.length_of_rib);
            this.X_Axis_MarksLabel(g, 50, 50 + shift_down, this.prv.length_of_rib * 2, this.d1, font, this.prv.length_of_rib, 2);
        }
        if (this.prv.Y_Axis_Labels) {
            g.setColor(Color.gray);
            this.Y_Axis_Marks(g, 50, 50, 10, this.d1, font, 0.01);
            g.setColor(Color.black);
            this.Y_Axis_Marks(g, 50, 50, 2, this.d1, font, 0.05);
            this.Y_Axis_MarksLabel1(g, 50, 50, 5, this.d1, font, 0.02);
            this.Y_Axis_MarksLabel1(g, 50, 50, 10, this.d1, font, 0.01);
            this.Y_Axis_MarksLabel(g, 150, 50, 4, this.d1, font, 0.0625, 1.0);
            this.Y_Axis_MarksLabel(g, 250, 50, 4, this.d1, font, 0.0625, 4.0);
            this.Y_Axis_MarksLabel(g, 350, 50, 14, this.d1, font, 0.05, this.prv.length_of_rib);
        }
    }

    public void other() {
    }

    private static void createAndShowGUI() {
        int setsize_x = 500;
        int setsize_y = 500;
        RibPrinterVariables prv = new RibPrinterVariables();
        prv.stations = 15;
        prv.length_of_rib = 6;
        prv.X_Axis_Labels = true;
        prv.Y_Axis_Labels = true;
        JFrame frame = new JFrame("Balsa Rib Printer");
        frame.setDefaultCloseOperation(3);
        JMenuBar greenMenuBar = new JMenuBar();
        greenMenuBar.setOpaque(true);
        greenMenuBar.setBackground(new Color(154, 165, 127));
        greenMenuBar.setPreferredSize(new Dimension(200, 20));
        frame.setJMenuBar(greenMenuBar);
        CurveDraw c = new CurveDraw(prv);
        frame.getContentPane().add((Component)c, "Center");
        c.setPreferredSize(new Dimension(setsize_x, setsize_y));
        frame.pack();
        frame.setVisible(true);
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CurveDraw.createAndShowGUI();
            }
        });
    }

    static final class AxisPrams {
        static final boolean x_axis_top = false;
        static final boolean x_axis_centered = true;
        static final boolean x_axis_bottom = false;

        AxisPrams() {
        }

        static final class X_Axis_Bottom {
            static final boolean label_on_Top = false;
            static final boolean label_on_Bottom = false;

            X_Axis_Bottom() {
            }
        }

        static final class X_Axis_Centered {
            static final boolean label_on_Top = false;
            static final boolean label_on_Bottom = true;

            X_Axis_Centered() {
            }
        }

        static final class X_Axis_Top {
            static final boolean label_on_Top = false;
            static final boolean label_on_Bottom = false;

            X_Axis_Top() {
            }
        }
    }

    static final class AxisPrams_1 {
        static final boolean x_axis_top = true;
        static final boolean x_axis_centered = false;
        static final boolean x_axis_bottom = true;

        AxisPrams_1() {
        }

        static final class X_Axis_Bottom {
            static final boolean label_on_Top = false;
            static final boolean label_on_Bottom = true;

            X_Axis_Bottom() {
            }
        }

        static final class X_Axis_Centered {
            static final boolean label_on_Top = true;
            static final boolean label_on_Bottom = true;

            X_Axis_Centered() {
            }
        }

        static final class X_Axis_Top {
            static final boolean label_on_Top = true;
            static final boolean label_on_Bottom = false;

            X_Axis_Top() {
            }
        }
    }
}

